; musicA.s
; AFRICA by Toto, 1982
; ColecoVision music composed by Daniel Bienvenu aka NewColeco
; April - May 2018

	.module sounds
    
	; global from this code
	.globl  _snd_table
	.globl  _africa_music
	.area _CODE

africa_ch0:
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x53,0x16,0x16,0x11
	.db 0x02,0xc4,0x02,0xe2,0x11 ; tst -
	.db 0x02,0x53,0x06,0x16,0x11
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x45,0x06,0x1b,0x11 ; DRUM
	.db 0x02,0x53,0x18,0x16,0x11
	;.db 0x02,0x53,0x10,0x16,0x13
	;
	.db 0x18

africa_ch3_01:
	.db 0xc0,0x51,0xf0,0x18 ; F#2
	.db 0xc0,0x36,0xf0,0x08 ; C#3
	.db 0xc0,0x28,0xf0,0x20 ; F#3
	.db 0xc0,0x66,0xf0,0x18 ; D2
	.db 0xc0,0x44,0xf0,0x08 ; A2
	.db 0xc0,0x33,0xf0,0x20 ; D3
	.db 0xc0,0x44,0xf0,0x18 ; A2
	.db 0xc0,0x2D,0xf0,0x08 ; E3
	.db 0xc0,0x22,0xf0,0x20 ; A3
	.db 0xc0,0x5A,0xf0,0x18 ; E2
	.db 0xc0,0x3C,0xf0,0x08 ; B2
	.db 0xc0,0x2D,0xf0,0x20 ; E3
	.db 0xd8

africa_ch2_01:
	.db 0x82,0x94,0x81,0x10,0x17,0x51 ; C#4
	;
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xbe,0x50,0x08,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x18,0x18,0x51 ; D5 ;;
	.db 0x82,0xbe,0x50,0x08,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x10,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x08,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x10,0x18,0x51 ; D5
	.db 0x82,0xca,0x50,0x30,0x18,0x51 ; C#5;;
	.db 0x82,0xe2,0x50,0x08,0x18,0x51 ; B4
	.db 0x82,0xe2,0x50,0x28,0x18,0x51 ; B4
	.db 0x82,0x0d,0x71,0x0a,0x17,0x51 ; G#4
	.db 0x82,0xfe,0x70,0x0b,0x17,0x51 ; A4
	.db 0x82,0x0d,0x71,0x0b,0x17,0x51 ; G#4
	;;
	.db 0x82,0x94,0x81,0x10,0x17,0x51 ; C#4
	;
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xbe,0x50,0x08,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x10,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x10,0x18,0x51 ; D5
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x20,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xaa,0x50,0x10,0x18,0x51 ; E5
	.db 0x82,0xaa,0x50,0x28,0x18,0x51 ; E5
	.db 0x82,0x0d,0x71,0x0a,0x17,0x51 ; G#4
	.db 0x82,0xfe,0x70,0x0b,0x17,0x51 ; A4
	.db 0x82,0x0d,0x71,0x0b,0x17,0x51 ; G#4
	;;
africa_ch2_01b:
	.db 0x82,0x94,0x81,0x10,0x17,0x51 ; C#4
	.db 0x82,0xfe,0x50,0x10,0x18,0x51 ; A4
	.db 0x82,0xfe,0x50,0x10,0x18,0x51 ; A4
	.db 0x82,0xfe,0x50,0x08,0x18,0x51 ; A4
	.db 0x83,0xaa,0x50,0x08,0x11,0xfe,0x18,0x51 ; E5
	.db 0x83,0x97,0x60,0x07,0x12,0x03,0x18,0x51 ; F#5
	.db 0x82,0xaa,0x70,0x18,0x16,0x51 ; E5
	.db 0x82,0x97,0x50,0x10,0x18,0x51 ; F#5
	.db 0x82,0xaa,0x50,0x08,0x18,0x51 ; E5
	.db 0x82,0xaa,0x50,0x38,0x18,0x51 ; E5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xE2,0x50,0x28,0x18,0x51 ; B4
	.db 0x82,0x0d,0x71,0x0a,0x17,0x51 ; G#4
	.db 0x82,0xfe,0x70,0x0b,0x17,0x51 ; A4
	.db 0x82,0x0d,0x71,0x0b,0x17,0x51 ; G#4
	.db 0x98

africa_ch1_01:
	.db 0x42,0xFE,0x80,0x10,0x17,0x51 ; A4
	;
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x18,0x17,0x51 ; A5 ;;
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x30,0x17,0x51 ; A5 ;;
	.db 0x42,0x87,0x40,0x08,0x17,0x51 ; G#5
	.db 0x42,0x87,0x40,0x48,0x17,0x51 ; G#5
	;;
	.db 0x42,0xFE,0x80,0x10,0x17,0x51 ; A4
	;
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x20,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x87,0x40,0x10,0x17,0x51 ; G#5
	.db 0x42,0x87,0x40,0x48,0x17,0x51 ; G#5
	;;
africa_ch1_01b:
	.db 0x42,0xFE,0x80,0x10,0x17,0x51 ; A4
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x28,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x38,0x17,0x51 ; A5
	.db 0x42,0x87,0x40,0x08,0x17,0x51 ; G#5
	.db 0x42,0x87,0x40,0x48,0x17,0x51 ; G#5
	.db 0x58

africa_ch3_02:
	.db 0xc0,0x51,0xf0,0x18 ; F#2
	.db 0xc0,0x36,0xf0,0x08 ; C#3
	.db 0xc0,0x28,0xf0,0x20 ; F#3
	.db 0xc0,0x66,0xf0,0x18 ; D2
	.db 0xc0,0x44,0xf0,0x08 ; A2
	.db 0xc0,0x33,0xf0,0x20 ; D3
	.db 0xc0,0x44,0xf0,0x18 ; A2
	.db 0xc0,0x2D,0xf0,0x08 ; E3
	.db 0xc0,0x22,0xf0,0x20 ; A3
	.db 0xc0,0x6C,0xf0,0x18 ; C#2
	.db 0xc0,0x48,0xf0,0x08 ; G#2
	.db 0xc0,0x36,0xf0,0x20 ; C#3
	.db 0xc0,0x5A,0xf0,0x18 ; E2
	.db 0xc0,0x3C,0xf0,0x08 ; B2
	.db 0xc0,0x2D,0xf0,0x20 ; E3
	.db 0xc0,0x51,0xf0,0x18 ; F#2
	.db 0xc0,0x36,0xf0,0x08 ; C#3
	.db 0xc0,0x48,0xf0,0x20 ; G#2
	.db 0xd0

africa_ch2_02:
	.db 0x82,0x94,0x81,0x10,0x17,0x51 ; C#4
	;
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xbe,0x50,0x10,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x08,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x10,0x18,0x51 ; D5
	.db 0x82,0xbe,0x50,0x18,0x18,0x51 ; D5
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xca,0x50,0x10,0x18,0x51 ; C#5
	.db 0x82,0xe2,0x50,0x18,0x18,0x51 ; B4
	.db 0x82,0xe2,0x50,0x28,0x18,0x51 ; B4
	.db 0x82,0x2e,0x51,0x08,0x18,0x51 ; F#4
	.db 0x82,0x53,0x51,0x10,0x18,0x51 ; E4
	.db 0x82,0xe2,0x50,0x28,0x18,0x51 ; B4
	.db 0x82,0xca,0x50,0x08,0x18,0x51 ; C#5
	.db 0x82,0xe2,0x50,0x10,0x18,0x51 ; B4
	.db 0x82,0xfe,0x50,0x28,0x17,0x51 ; A4
	.db 0x82,0x53,0x51,0x18,0x18,0x51 ; E4
	.db 0x90

africa_ch1_02:
	.db 0x42,0xFE,0x80,0x10,0x17,0x51 ; A4
	;
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x18,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x7F,0x40,0x10,0x17,0x51 ; A5
	.db 0x42,0x87,0x40,0x18,0x17,0x51 ; G#5
	.db 0x42,0x87,0x40,0x28,0x17,0x51 ; G#5
	.db 0x42,0x97,0x40,0x08,0x17,0x51 ; F#5
	.db 0x42,0xAA,0x40,0x10,0x17,0x51 ; E5
	.db 0x42,0x87,0x40,0x28,0x17,0x51 ; G#5
	.db 0x42,0x7F,0x40,0x08,0x17,0x51 ; A5
	.db 0x42,0x87,0x40,0x10,0x17,0x51 ; G#5
	.db 0x42,0x97,0x40,0x28,0x17,0x51 ; F#5
	.db 0x42,0xAA,0x40,0x18,0x17,0x51 ; E5
	.db 0x50
	
;;;

; Write your CV sounds here
africa_ch0_03:
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x53,0x16,0x16,0x11
	.db 0x02,0xc4,0x02,0xe2,0x11 ; tst-
	.db 0x02,0x53,0x06,0x16,0x11
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x45,0x06,0x1b,0x11 ; DRUM
	.db 0x02,0x53,0x08,0x16,0x13
	.db 0x00,0x00,0xf0,0x08
	.db 0x02,0x53,0x08,0x16,0x13
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x53,0x0e,0x16,0x13
	.db 0x02,0x53,0x08,0x16,0x13
	.db 0x02,0xc4,0x02,0xe2,0x11 ; tst-
	.db 0x02,0x53,0x06,0x16,0x11
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x45,0x06,0x1b,0x11 ; DRUM
	.db 0x02,0x53,0x18,0x16,0x13
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x53,0x16,0x16,0x11
	.db 0x02,0xc4,0x02,0xe2,0x11 ; tst-
	.db 0x02,0x53,0x06,0x16,0x11
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x45,0x06,0x1b,0x11 ; DRUM
	.db 0x02,0x53,0x18,0x16,0x13
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x53,0x16,0x16,0x11
	.db 0x02,0xc4,0x02,0xe2,0x11 ; tst-
	.db 0x02,0x53,0x06,0x16,0x11
	.db 0x02,0xb4,0x02,0xd2,0x11 ; tst
	.db 0x02,0x45,0x06,0x1b,0x11 ; DRUM
	.db 0x02,0x53,0x18,0x16,0x13
	.db 0x18

africa_ch3_03:
	.db 0xc0,0x44,0xf0,0x50 ; A2
	.db 0xc0,0x48,0xf0,0x10 ; G#2
	.db 0xc0,0x6C,0xf0,0xA0 ; C#2
africa_ch3_03intro:
	.db 0xc0,0x88,0xf0,0x50 ; A1
	.db 0xc0,0x90,0xf0,0x10 ; G#1
	.db 0xc0,0x6C,0xf0,0xA0 ; C#2
	.db 0xd8

africa_ch2_03:
	.db 0x82,0x94,0x61,0x18,0x17,0x51 ; C#4
	.db 0x82,0x94,0x61,0x08,0x17,0x51 ; C#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x94,0x61,0x08,0x17,0x51 ; C#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x94,0x61,0x08,0x17,0x51 ; C#4
	.db 0x82,0x94,0x61,0x10,0x17,0x51 ; C#4
	.db 0x82,0xc5,0x61,0x10,0x17,0x51 ; B3
	.db 0x82,0x53,0x61,0x10,0x17,0x51 ; E4
	;;
	.db 0x82,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x82,0xe2,0x70,0x08,0x17,0x12 ; B4
	.db 0x82,0x0d,0x71,0x08,0x17,0x12 ; G#4
	.db 0x82,0xe2,0x70,0x08,0x17,0x12 ; B4
	.db 0x82,0x0d,0x71,0x08,0x17,0x12 ; G#4
	.db 0x80,0x00,0xf0,0x10
	.db 0x82,0xe2,0x70,0x08,0x17,0x12 ; B4
	.db 0x82,0x0d,0x71,0x08,0x17,0x12 ; G#4
	.db 0x82,0xe2,0x70,0x08,0x17,0x12 ; B4
	.db 0x82,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x82,0xe2,0x70,0x08,0x17,0x12 ; B4
	.db 0x82,0x0d,0x71,0x08,0x17,0x12 ; G#4
	;.db 0x80,0x00,0xf0,0x08
	.db 0x82,0xe2,0x80,0x08,0x17,0x12 ; B4	
	.db 0x82,0x0d,0x71,0x08,0x17,0x12 ; G#4
	;.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x97,0x70,0x08,0x17,0x12 ; F#5
	.db 0x82,0xe2,0x70,0x10,0x17,0x12 ; B4
	.db 0x98

africa_ch1_03:
	.db 0x42,0xfc,0x81,0x18,0x17,0x51 ; A3
	.db 0x42,0xfc,0x81,0x08,0x17,0x51 ; A3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xfc,0x81,0x08,0x17,0x51 ; A3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xfc,0x81,0x08,0x17,0x51 ; A3
	.db 0x42,0xfc,0x81,0x10,0x17,0x51 ; A3
	.db 0x42,0x1b,0x82,0x10,0x17,0x51 ; G#3
	.db 0x42,0x94,0x81,0x10,0x17,0x51 ; C#4
	;;
	.db 0x42,0x97,0x70,0x08,0x17,0x12 ; F#5
	.db 0x42,0xAA,0x70,0x08,0x17,0x12 ; E5
	.db 0x42,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x42,0xAA,0x70,0x08,0x17,0x12 ; E5
	.db 0x42,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x42,0x97,0x70,0x10,0x17,0x12 ; F#5 ;
	.db 0x42,0xAA,0x70,0x08,0x17,0x12 ; E5
	.db 0x42,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x42,0xAA,0x70,0x08,0x17,0x12 ; E5
	.db 0x42,0x97,0x70,0x08,0x17,0x12 ; F#5
	.db 0x42,0xAA,0x70,0x08,0x17,0x12 ; E5
	.db 0x42,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x42,0xe2,0x80,0x08,0x17,0x12 ; B4
	.db 0x42,0xca,0x70,0x08,0x17,0x12 ; C#5
	.db 0x42,0x97,0x70,0x08,0x17,0x12 ; F#5
	.db 0x42,0xAA,0x70,0x10,0x17,0x12 ; E5
	.db 0x58

africa_ch2_03b:
	.db 0x82,0x94,0x61,0x18,0x17,0x51 ; C#4
	.db 0x82,0x94,0x61,0x08,0x17,0x51 ; C#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x94,0x61,0x08,0x17,0x51 ; C#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x94,0x61,0x08,0x17,0x51 ; C#4
	.db 0x82,0x94,0x61,0x10,0x17,0x51 ; C#4
	.db 0x82,0xc5,0x61,0x10,0x17,0x51 ; B3
	.db 0x82,0x53,0x61,0x20,0x17,0x51 ; E4
	.db 0x90

africa_ch1_03b:
	.db 0x42,0xfc,0x81,0x18,0x17,0x51 ; A3
	.db 0x42,0xfc,0x81,0x08,0x17,0x51 ; A3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xfc,0x81,0x08,0x17,0x51 ; A3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xfc,0x81,0x08,0x17,0x51 ; A3
	.db 0x42,0xfc,0x81,0x10,0x17,0x51 ; A3
	.db 0x42,0x1b,0x82,0x10,0x17,0x51 ; G#3
	.db 0x42,0x94,0x81,0x20,0x17,0x51 ; C#4
	.db 0x50

africa_ch3_04:
	.db 0xc0,0x79,0xf0,0x20 ; B1
	.db 0xc0,0x3C,0xf0,0x20 ; B2
	;
	.db 0xc0,0x60,0xf0,0x20 ; D#2
	.db 0xc0,0x3C,0xf0,0x20 ; B2
	;
	.db 0xc0,0x90,0xf0,0x20 ; G#1
	.db 0xc0,0x48,0xf0,0x20 ; G#2
	;
	.db 0xc0,0xA1,0xf0,0x20 ; F#1
	.db 0xc0,0x51,0xf0,0x20 ; F#2
	;
	.db 0xc0,0x88,0xf0,0x20 ; A1
	.db 0xc0,0x44,0xf0,0x20 ; A2
	;
	.db 0xc0,0xA1,0xf0,0x20 ; F#1
	.db 0xc0,0x51,0xf0,0x20 ; F#2
	;
	.db 0xc0,0x90,0xf0,0x20 ; G#1
	.db 0xc0,0x48,0xf0,0x20 ; G#2
	;
	.db 0xd8

africa_ch2_04:
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x5D,0x52,0x08,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x08,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x08,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x20,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x08,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x18,0x16,0x51 ; F#3
	.db 0x82,0x1B,0x52,0x10,0x16,0x51 ; G#3
	.db 0x82,0xE0,0x51,0x08,0x16,0x51 ; A#3
	.db 0x82,0xC5,0x51,0x28,0x16,0x51 ; B3
	.db 0x80,0x00,0xf0,0x18
	.db 0x82,0xCF,0x52,0x08,0x16,0x51 ; D#3
	.db 0x82,0xCF,0x52,0x08,0x16,0x51 ; D#3
	.db 0x82,0xCF,0x52,0x18,0x16,0x51 ; D#3
	.db 0x82,0xA7,0x52,0x10,0x16,0x51 ; E3
	.db 0x82,0x5D,0x52,0x08,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x10,0x16,0x51 ; F#3
	.db 0x82,0xA7,0x52,0x18,0x16,0x51 ; E3
	.db 0x82,0xA7,0x52,0x10,0x16,0x51 ; E3
	.db 0x82,0xCF,0x52,0x10,0x16,0x51 ; D#3
	.db 0x82,0x27,0x53,0x18,0x16,0x51 ; C#3
	.db 0x82,0x8A,0x53,0x08,0x16,0x51 ; B2
	.db 0x82,0x27,0x53,0x10,0x16,0x51 ; C#3
	.db 0x82,0x8A,0x53,0x08,0x16,0x51 ; B2
	.db 0x82,0xCF,0x52,0x30,0x16,0x51 ; D#3
	.db 0x82,0x27,0x53,0x08,0x16,0x51 ; C#3
	.db 0x82,0x8A,0x53,0x10,0x16,0x51 ; B2
	.db 0x98

africa_ch1_04:
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0x5C,0x72,0x08,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x08,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x08,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x20,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x08,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x18,0x17,0x51 ; F#3
	.db 0x42,0x1A,0x72,0x10,0x17,0x51 ; G#3
	.db 0x42,0xDF,0x71,0x08,0x17,0x51 ; A#3
	.db 0x42,0xC4,0x71,0x28,0x17,0x51 ; B3
	.db 0x40,0x00,0xf0,0x18
	.db 0x42,0xCE,0x72,0x08,0x17,0x51 ; D#3
	.db 0x42,0xCE,0x72,0x08,0x17,0x51 ; D#3
	.db 0x42,0xCE,0x72,0x18,0x17,0x51 ; D#3
	.db 0x42,0xA6,0x72,0x10,0x17,0x51 ; E3
	.db 0x42,0x5C,0x72,0x08,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x10,0x17,0x51 ; F#3
	.db 0x42,0xA6,0x72,0x18,0x17,0x51 ; E3
	.db 0x42,0xA6,0x72,0x10,0x17,0x51 ; E3
	.db 0x42,0xCE,0x72,0x10,0x17,0x51 ; D#3
	.db 0x42,0x26,0x73,0x18,0x17,0x51 ; C#3
	.db 0x42,0x89,0x73,0x08,0x17,0x51 ; B2
	.db 0x42,0x26,0x73,0x10,0x17,0x51 ; C#3
	.db 0x42,0x89,0x73,0x08,0x17,0x51 ; B2
	.db 0x42,0xCE,0x72,0x30,0x17,0x51 ; D#3
	.db 0x42,0x26,0x73,0x08,0x17,0x51 ; C#3
	.db 0x42,0x89,0x73,0x10,0x17,0x51 ; B2
	.db 0x48
	
africa_ch2_05:
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x5D,0x52,0x10,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x10,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x10,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x10,0x16,0x51 ; F#3
	.db 0x82,0x5D,0x52,0x10,0x16,0x51 ; F#3
	.db 0x82,0x1B,0x52,0x10,0x16,0x51 ; G#3
	.db 0x82,0xE0,0x51,0x10,0x16,0x51 ; A#3
	.db 0x82,0xC5,0x51,0x28,0x16,0x51 ; B3
	.db 0x80,0x00,0xf0,0x20
	.db 0x82,0x67,0x51,0x08,0x16,0x51 ; D#4
	.db 0x82,0x67,0x51,0x10,0x16,0x51 ; D#4
	.db 0x82,0x53,0x51,0x18,0x16,0x51 ; E4
	.db 0x82,0x2e,0x51,0x10,0x16,0x51 ; F#4
	.db 0x90

africa_ch2_05b:
	.db 0x82,0x2e,0x61,0x08,0x17,0x51 ; F#4
	.db 0x82,0x53,0x61,0x10,0x17,0x51 ; E4
	.db 0x82,0x53,0x61,0x10,0x17,0x51 ; E4
	.db 0x82,0x67,0x61,0x08,0x17,0x51 ; D#4
	.db 0x82,0x53,0x61,0x10,0x17,0x51 ; E4

	.db 0x82,0x94,0x61,0x10,0x17,0x51 ; C#4
	.db 0x82,0xc5,0x61,0x10,0x17,0x51 ; B3
	.db 0x82,0x53,0x61,0x20,0x17,0x51 ; E4

	.db 0x90

africa_ch1_05:
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0x5C,0x72,0x10,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x10,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x10,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x10,0x17,0x51 ; F#3
	.db 0x42,0x5C,0x72,0x10,0x17,0x51 ; F#3
	.db 0x42,0x1A,0x72,0x10,0x17,0x51 ; G#3
	.db 0x42,0xDF,0x71,0x10,0x17,0x51 ; A#3
	.db 0x42,0xC4,0x71,0x28,0x17,0x51 ; B3
	.db 0x40,0x00,0xf0,0x20
	.db 0x42,0xC5,0x71,0x08,0x17,0x51 ; B3
	.db 0x42,0xC5,0x71,0x10,0x17,0x51 ; B3
	.db 0x42,0x94,0x71,0x18,0x17,0x51 ; C#4
	.db 0x42,0x67,0x71,0x10,0x17,0x51 ; D#4
	.db 0x50

africa_ch1_05b:
	.db 0x42,0x67,0x71,0x08,0x17,0x51 ; D#4
	.db 0x42,0x94,0x71,0x10,0x17,0x51 ; C#4
	.db 0x42,0x94,0x71,0x10,0x17,0x51 ; C#4
	.db 0x42,0xC5,0x71,0x08,0x17,0x51 ; B3
	.db 0x42,0x94,0x71,0x10,0x17,0x51 ; C#4

	.db 0x42,0xfc,0x81,0x10,0x17,0x51 ; A3
	.db 0x42,0x1b,0x82,0x10,0x17,0x51 ; G#3
	.db 0x42,0x94,0x81,0x20,0x17,0x51 ; C#4
	.db 0x50

; FLUTE
africa_ch1_06:
	.db 0x42,0xE2,0xd0,0x40,0xe3,0x21 ; B4
	.db 0x42,0xF0,0xd0,0x40,0xe3,0x21 ; A#4
	.db 0x42,0x0d,0xd1,0x40,0xe3,0x21 ; G#4
	.db 0x42,0x2e,0xd1,0x40,0xe3,0x21 ; F#4
	.db 0x42,0xfe,0xd0,0x40,0xe3,0x21 ; A4
	.db 0x42,0x0d,0xd1,0x40,0xe3,0x21 ; G#4
	.db 0x42,0xE2,0xd0,0x28,0xe3,0x21 ; B4
	.db 0x42,0xfe,0xd0,0x08,0xe3,0x21 ; A4
	.db 0x42,0x0d,0xd1,0x08,0xe3,0x21 ; G#4
	.db 0x42,0xfe,0xd0,0x08,0xe3,0x21 ; A4
	.db 0x50

africa_ch2_06:
	.db 0x80,0x00,0xf0,0x10
	.db 0x82,0x5D,0x62,0x08,0x17,0x51 ; F#3
	.db 0x82,0x5D,0x62,0x10,0x17,0x51 ; F#3
	.db 0x82,0x5D,0x62,0x10,0x17,0x51 ; F#3
	.db 0x82,0xE0,0x61,0x10,0x17,0x51 ; A#3
	.db 0x82,0xE0,0x61,0x10,0x17,0x51 ; A#3
	.db 0x82,0xC5,0x61,0x10,0x17,0x51 ; B3
	.db 0x82,0x94,0x61,0x10,0x17,0x51 ; C#4
	.db 0x82,0x67,0x61,0x18,0x17,0x51 ; D#4 ;;
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0xCF,0x62,0x08,0x17,0x51 ; D#3
	.db 0x82,0xCF,0x62,0x10,0x17,0x51 ; D#3
	.db 0x82,0xCF,0x62,0x10,0x17,0x51 ; D#3
	.db 0x82,0xCF,0x62,0x08,0x17,0x51 ; D#3
	.db 0x82,0xCF,0x62,0x08,0x17,0x51 ; D#3
	.db 0x82,0xCF,0x62,0x08,0x17,0x51 ; D#3
	.db 0x82,0xA7,0x62,0x10,0x17,0x51 ; E3
	.db 0x82,0x5D,0x62,0x18,0x17,0x51 ; F#3
	.db 0x82,0x5D,0x62,0x10,0x17,0x51 ; F#3
	.db 0x82,0xA7,0x62,0x10,0x17,0x51 ; E3
	.db 0x82,0xA7,0x62,0x10,0x17,0x51 ; E3
	.db 0x82,0xCF,0x62,0x08,0x17,0x51 ; D#3
	.db 0x82,0x27,0x63,0x10,0x17,0x51 ; C#3
	.db 0x82,0x27,0x63,0x10,0x17,0x51 ; C#3
	.db 0x82,0x8A,0x63,0x08,0x17,0x51 ; B2
	.db 0x82,0x27,0x63,0x10,0x17,0x51 ; C#3
	.db 0x82,0x8A,0x63,0x10,0x17,0x51 ; B2
	.db 0x82,0xCF,0x62,0x28,0x17,0x51 ; D#3
	.db 0x82,0x27,0x63,0x08,0x17,0x51 ; C#3
	.db 0x82,0x8A,0x63,0x08,0x17,0x51 ; B2
	.db 0x82,0x27,0x63,0x08,0x17,0x51 ; C#3
	.db 0x90

;;; SOLO

; FLUTE + XYLO (SOLO PART 1)
africa_ch2_07:
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0xe2,0xd0,0x08,0xe3,0x21 ; B4
	.db 0x82,0x0d,0xd1,0x08,0xe3,0x21 ; G#4
	.db 0x82,0x2e,0xd1,0x08,0xe3,0x21 ; F#4
	.db 0x82,0x0d,0xd1,0x08,0xe3,0x21 ; G#4
	.db 0x82,0x2e,0xd1,0x08,0xe3,0x21 ; F#4
	.db 0x82,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x82,0x2e,0xd1,0x08,0xe3,0x21 ; F#4
	.db 0x82,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x82,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x82,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x82,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x82,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x82,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x82,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x82,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x82,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x82,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x82,0x5d,0xd2,0x08,0xe3,0x21 ; F#3
	.db 0x82,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x82,0x5d,0xd2,0x08,0xe3,0x21 ; F#3
	.db 0x82,0xcf,0xd2,0x08,0xe3,0x21 ; D#3
	.db 0x82,0x5d,0xd2,0x20,0xe3,0x21 ; F#3
	.db 0x82,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x82,0xcf,0xd2,0x08,0xe3,0x21 ; D#3
	.db 0x80,0x00,0xf0,0x20
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x94,0x71,0x08,0x17,0x12 ; C#4
	.db 0x82,0x53,0x71,0x08,0x17,0x12 ; E4
	.db 0x82,0xCA,0x70,0x08,0x17,0x12 ; C#5
	.db 0x82,0xE2,0x70,0x08,0x17,0x12 ; B4
	.db 0x82,0xF0,0x70,0x08,0x17,0x12 ; A#4
	.db 0x82,0x0D,0x71,0x08,0x17,0x12 ; G#4
	.db 0x82,0x2E,0x71,0x08,0x17,0x12 ; F#4
	.db 0x82,0x53,0x71,0x08,0x17,0x12 ; E4
	.db 0x82,0x67,0x71,0x08,0x17,0x12 ; D#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x0D,0x71,0x08,0x17,0x12 ; G#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x2E,0x71,0x08,0x17,0x12 ; F#4
	.db 0x80,0x00,0xf0,0x08
	.db 0x82,0x53,0x71,0x08,0x17,0x12 ; E4
	.db 0x82,0x67,0x71,0x10,0x17,0x12 ; D#4
	.db 0x82,0x94,0x71,0x10,0x17,0x12 ; C#4
	.db 0x82,0xC5,0x71,0x10,0x17,0x12 ; B3
	.db 0x82,0x2E,0x71,0x10,0x17,0x12 ; F#4
	.db 0x82,0x67,0x71,0x10,0x17,0x12 ; D#4
	.db 0x82,0x94,0x71,0x08,0x17,0x12 ; C#4
	.db 0x82,0xC5,0x71,0x08,0x17,0x12 ; B3
	.db 0x90

; FLUTE (SOLO PART 1)
africa_ch1_07:
.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xb4,0xd0,0x08,0xe3,0x21 ; D#5
	.db 0x42,0xca,0xd0,0x08,0xe3,0x21 ; C#5
	.db 0x42,0xe2,0xd0,0x08,0xe3,0x21 ; B4
	.db 0x42,0xca,0xd0,0x08,0xe3,0x21 ; C#4
	.db 0x42,0xe2,0xd0,0x08,0xe3,0x21 ; B4
	.db 0x42,0x0d,0xd1,0x08,0xe3,0x21 ; G#4
	.db 0x42,0xe2,0xd0,0x08,0xe3,0x21 ; B4
	.db 0x42,0x0d,0xd1,0x08,0xe3,0x21 ; G#4
	.db 0x42,0x2e,0xd1,0x08,0xe3,0x21 ; F#4
	.db 0x42,0x0d,0xd1,0x08,0xe3,0x21 ; G#4
	.db 0x42,0x2e,0xd1,0x08,0xe3,0x21 ; F#4
	.db 0x42,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x42,0x2e,0xd1,0x08,0xe3,0x21 ; F#4
	.db 0x42,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x42,0xc5,0xd1,0x20,0xe3,0x21 ; B3
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x40,0x00,0xf0,0x20
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xA7,0xd2,0x08,0xe3,0x21 ; E3
	.db 0x42,0xE0,0xd1,0x08,0xe3,0x21 ; A#3
	.db 0x42,0x53,0xd1,0x08,0xe3,0x21 ; E4
	.db 0x42,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x42,0xE0,0xd1,0x08,0xe3,0x21 ; A#3
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x42,0x5d,0xd2,0x08,0xe3,0x21 ; F#3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0xE0,0xd1,0x08,0xe3,0x21 ; A#3
	.db 0x40,0x00,0xf0,0x08
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x42,0x5d,0xd2,0x10,0xe3,0x21 ; F#3
	.db 0x42,0xA7,0xd2,0x10,0xe3,0x21 ; E3
	.db 0x42,0xcf,0xd2,0x10,0xe3,0x21 ; D#3
	.db 0x42,0xc5,0xd1,0x10,0xe3,0x21 ; B3
	.db 0x42,0x5d,0xd2,0x10,0xe3,0x21 ; F#3
	.db 0x42,0xA7,0xd2,0x08,0xe3,0x21 ; E3
	.db 0x42,0xcf,0xd2,0x08,0xe3,0x21 ; D#3
	.db 0x50

; XYLO (SOLO PART 2)
africa_ch2_08:
	.db 0x82,0x94,0x71,0x08,0x17,0x12 ; C#4
	.db 0x82,0xC5,0x71,0x08,0x17,0x12 ; B3
	.db 0x82,0x94,0x71,0x08,0x17,0x12 ; C#4
	.db 0x82,0x67,0x71,0x08,0x17,0x12 ; D#4
	.db 0x82,0x94,0x71,0x08,0x17,0x12 ; C#4
	.db 0x82,0x67,0x71,0x08,0x17,0x12 ; D#4
	.db 0x82,0x2E,0x71,0x08,0x17,0x12 ; F#4
	.db 0x82,0x67,0x71,0x08,0x17,0x12 ; D#4
	.db 0x82,0x2E,0x71,0x08,0x17,0x12 ; F#4
	.db 0x82,0x0D,0x71,0x08,0x17,0x12 ; G#4
	.db 0x82,0x2E,0x71,0x08,0x17,0x12 ; F#4
	.db 0x82,0xCA,0x70,0x02,0x17,0x12 ; C#5
	.db 0x82,0xB4,0x70,0x06,0x17,0x12 ; D#5
	.db 0xa8
	.db 0x82,0xE2,0x70,0x02,0x17,0x12 ; B4
	.db 0x82,0xCA,0x70,0x06,0x17,0x12 ; C#5
	.db 0xa8
	.db 0x82,0xE2,0x70,0x28,0x17,0x12 ; B4
	.db 0x80,0x00,0xf0,0x20
	.db 0x82,0x67,0x51,0x08,0x16,0x51 ; D#4
	.db 0x82,0x67,0x51,0x10,0x16,0x51 ; D#4
	.db 0x82,0x53,0x51,0x18,0x16,0x51 ; E4
	.db 0x82,0x2e,0x51,0x10,0x16,0x51 ; F#4
	.db 0x90

; FLUTE (SOLO PART 2)
africa_ch1_08:
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x42,0x5d,0xd2,0x08,0xe3,0x21 ; F#3
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x42,0x1b,0xd2,0x08,0xe3,0x21 ; G#3
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0xc5,0xd1,0x08,0xe3,0x21 ; B3
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0x67,0xd1,0x08,0xe3,0x21 ; D#4
	.db 0x42,0x94,0xd1,0x08,0xe3,0x21 ; C#4
	.db 0x42,0xf0,0xd0,0x02,0xe3,0x21 ; A#4
	.db 0x42,0xe2,0xd0,0x06,0xe3,0x21 ; B4
	.db 0x68
	.db 0x42,0x2e,0xd1,0x02,0xe3,0x21 ; F#4
	.db 0x42,0x0d,0xd1,0x06,0xe3,0x21 ; G#4
	.db 0x68
	.db 0x42,0x2e,0xd1,0x28,0xe3,0x21 ; F#4
	.db 0x40,0x00,0xf0,0x20
	.db 0x42,0xC5,0x71,0x08,0x17,0x51 ; B3
	.db 0x42,0xC5,0x71,0x10,0x17,0x51 ; B3
	.db 0x42,0x94,0x71,0x18,0x17,0x51 ; C#4
	.db 0x42,0x67,0x71,0x10,0x17,0x51 ; D#4
	.db 0x50

;;; END SOLO

_snd_table:
	.dw	#africa_ch0,0x702b ; = 1
	.dw	#africa_ch1_01,0x702b+10 ; = 2
	.dw	#africa_ch2_01,0x702b+20 ; = 3
	.dw	#africa_ch3_01,0x702b+30 ; = 4
	.dw	#africa_ch1_02,0x702b+10 ; = 5
	.dw	#africa_ch2_02,0x702b+20 ; = 6
	.dw	#africa_ch3_02,0x702b+30 ; = 7
	.dw	#africa_ch0_03,0x702b ; = 8
	.dw	#africa_ch1_03,0x702b+10 ; = 9
	.dw	#africa_ch2_03,0x702b+20 ; = A
	.dw	#africa_ch3_03,0x702b+30 ; = B
	.dw	#africa_ch3_03intro,0x702b+30 ; = C
	.dw	#africa_ch1_04,0x702b+10 ; = D
	.dw	#africa_ch2_04,0x702b+20 ; = E
	.dw	#africa_ch3_04,0x702b+30 ; = F
	.dw	#africa_ch1_03b,0x702b+10 ; = 10
	.dw	#africa_ch2_03b,0x702b+20 ; = 11
	.dw	#africa_ch1_05,0x702b+10 ; = 12
	.dw	#africa_ch2_05,0x702b+20 ; = 13
	.dw	#africa_ch1_05b,0x702b+10 ; = 14
	.dw	#africa_ch2_05b,0x702b+20 ; = 15
	.dw	#africa_ch1_06,0x702b+10 ; = 16
	.dw	#africa_ch2_06,0x702b+20 ; = 17
	.dw	#africa_ch1_07,0x702b+10 ; = 18
	.dw	#africa_ch2_07,0x702b+20 ; = 19
	.dw	#africa_ch1_01b,0x702b+10 ; = 1A
	.dw	#africa_ch2_01b,0x702b+20 ; = 1B
	.dw	#africa_ch1_08,0x702b+10 ; = 1C
	.dw	#africa_ch2_08,0x702b+20 ; = 1D
	
_africa_music :
	; RIFF ; INTRO ; BASS ONLY LOW NOTES TWICE
	.dw 0x0400
	.db 0xc8,0x09,0x0A,0x0C
africa_music_loop:
	; VERSE 1
	.dw 0x01C0
	.db 0xc1,0x0D,0x0E,0x0F
	.dw 0x0080
	.db 0xc8,0x10,0x11,0x0C
	.dw 0x01C0
	.db 0xc1,0x0D,0x0E,0x0F
	.dw 0x0080
	.db 0xc8,0x10,0x11,0x0C
	.dw 0x01C0
	.db 0xc1,0x0D,0x0E,0x0F
	.dw 0x0080
	.db 0xc8,0x10,0x11,0x0C
	.dw 0x0100
	.db 0xc1,0x12,0x13,0x0F
	.dw 0x0080 ;;
	.db 0xc8,0x14,0x15,0x0C ;;
	;; MISSING : DRUM SOLO
	;;; MISSING A MEASURE (80) OF DRUM TRANSITION
	; CHORUS
	.dw 0x0300
	.db 0xc1,0x02,0x03,0x04
	.dw 0x0180
	.db 0xc1,0x05,0x06,0x07
	; RIFF
	.dw 0x0200
	.db 0xc8,0x09,0x0A,0x0B	
	; VERSE 2
	.dw 0x01C0
	.db 0xc1,0x16,0x0E,0x0F
	.dw 0x0080
	.db 0xc8,0x10,0x11,0x0C
	.dw 0x01C0
	.db 0xc1,0x16,0x17,0x0F
	.dw 0x0080
	.db 0xc8,0x10,0x11,0x0C
	.dw 0x0100
	.db 0xc1,0x12,0x13,0x0F
	.dw 0x0080
	.db 0xc8,0x14,0x15,0x0C
	;; MISSING : DRUM SOLO
	; CHORUS
	.dw 0x0300
	.db 0xc1,0x02,0x03,0x04
	.dw 0x0180
	.db 0xc1,0x05,0x06,0x07
	; RIFF
	.dw 0x0200
	.db 0xc8,0x09,0x0A,0x0B		
	; FLUTE + XYLOPHONE SOLO
	.dw 0x01C0
	.db 0xc1,0x18,0x19,0x0F
	.dw 0x0080
	.db 0xc8,0x10,0x11,0x0C
	.dw 0x0100
	.db 0xc1,0x1C,0x1D,0x0F
	; VERSE TRANSITION
	.dw 0x0080 ;;
	.db 0xc8,0x14,0x15,0x0C ;;
	; CHORUS with AFRICA x 5
	.dw 0x0300
	.db 0xc1,0x02,0x03,0x04
	.dw 0x0100
	.db 0xc1,0x1A,0x1B,0x04
	.dw 0x0100
	.db 0xc1,0x1A,0x1B,0x04
	.dw 0x0100
	.db 0xc1,0x1A,0x1B,0x04
	.dw 0x0100
	.db 0xc1,0x1A,0x1B,0x04
	.dw 0x0180
	.db 0xc1,0x05,0x06,0x07
	; RIFF
	.dw 0x0200
	.db 0xc8,0x09,0x0A,0x0B		
	.dw africa_music_loop ; This loop the music over and over again
